"use client"

import { Dialog } from "@/components/ui/dialog"
import { useApplicationWorkflow } from "@/hooks/use-application-workflow"
import { TransformedAgencies } from "@/types/transformers"
import { ComponentWithClassName } from "@/types/utils"
import { WorkflowOption } from "@/types/workflow"
import { TransformedListUserResult } from "../type/transformers"
import { WorkflowDialogInvite } from "./workflow.dialog-invite"
import { WorkflowDialogRevoke } from "./workflow.dialog-revoke"
import { WorkflowDialogRevokeCurrentUser } from "./workflow.dialog-revoke-current-user"

type INTERNAL__WorkflowDialogProps = ComponentWithClassName<{ data: NonNullable<TransformedListUserResult>, agencies: TransformedAgencies, currentUser: { name: string } }>

export function WorkflowDialog(props: INTERNAL__WorkflowDialogProps) {
  const {
    resetWorkflow,
    workflow,
  } = useApplicationWorkflow()

  if (!workflow) {
    return
  }

  const content = INTERNAL__WorkflowDialogContent(workflow, props, resetWorkflow)
  return content && (
    <Dialog open defaultOpen onOpenChange={resetWorkflow}>
      {content}
    </Dialog>
  )
}

function INTERNAL__WorkflowDialogContent(workflow: NonNullable<WorkflowOption>, { data, agencies, currentUser, className }: INTERNAL__WorkflowDialogProps, setClose: () => void) {
  if (workflow.__tag === "INVITE_NEW_MEMBER") {
    return (
      <WorkflowDialogInvite setClose={setClose} agencies={agencies} className={className} />
    )
  }

  if (workflow.__tag === "REVOKE_MEMBER_PRIVILEDGES") {
    const potential = data.pending.find((d) => d.displayName === workflow.email) ?? data.verified.find((d) => d.displayName === workflow.email)
    if (!potential) {
      return null;
    }

    return potential.displayName === currentUser.name ? (
      <WorkflowDialogRevokeCurrentUser setClose={setClose} data={potential} className={className} />
    ) : (
      <WorkflowDialogRevoke setClose={setClose} data={potential} className={className} />
    )
  }

  return null
}

